--1. plya: fa, pizza (diary, mail)
--2. plya: liszt, kaja (orb)
--3. plya: vz, ko, arany (kereskedo)

FK =
{
	numBuiltHouses = 0,
	numBuiltFarms = 0,

   farm02Built = false,
	sawMillBuilt = false,
	waterMillBuilt = false,
	quarryBuilt = false,
	tavernBuilt = false,
	windMillBuilt = false,
	goldMineBuilt = false,
	specialBuilt = false,
	wortexBuilt = false,
	palaceP01Built = false,
	palaceP02Built = false,
	palaceP03Built = false,
	palaceP04Built = false,
	palaceP05Built = false,

	-- build menu: unlock building types
	sawMillUnlocked = false,
	farmsUnlocked = false,
	waterMillUnlocked = false,
	quarryUnlocked = false,
	tavernUnlocked = false,
	windMillUnlocked = false,
	goldMineUnlocked = false,
	specialUnlocked = false,
	wortexUnlocked = false,
	palaceUnlocked = false,

-- LEVEL-02 SPECIFIC VARIABLES
	activeObj = 0.0,    						-- current objective number
	completedObj = 0.0,						-- last completed objective number
	diaryState = false,
	msg01TimerIsOver = false,
	pirateNum = 0,
	pirateEnabled = false,
	boxGroupFilled = 0,						-- 0
	sackFilled = 0								-- 0
}

function OnEverySecond()

	if (event.Time == 0) then
		_ShowGUI(false)				-- player has no control yet

--		_ModifyResource("Meal", 500)	-- dev

--		_StartCutscene("cutscene_02a", 1, 0)					-- dev

		_StartCutscene("cutscene_02a", 3, 0)					-- level starting cutscene
--		_StartCutscene("cutscene_02a", 5, 0)					-- level starting cutscene

		_SetVariableBool("House01Enabled", true)
		_SetVariableBool("House02Enabled", true)
		_SetVariableBool("House03Enabled", true)
		_SetVariableBool("House04Enabled", true)

		_Build("House01", 100)
		_Build("House02", 100)
		_Build("House03", 100)
		_Build("House04", 100)
		_Build("SawMill", 100)
		_Build("Farm01", 100)
		_Build("Farm03", 100)
		_Build("Farm04", 100)
		_Build("WaterMill", 100)
		_Build("GoldMine", 100)

		_SetVariableBool("Orb04", true)

--		_StartParticle("global_warning", 680, 18)						-- dev
		_SetVariableBool("ShowObjectiveText", true)		-- 1 line onscreen objectives display on.
	end

			--=======--
	---=== Building unlocks ===---
	if (FK.sawMillUnlocked == false and 1 < FK.numBuiltHouses) then			-- sawmill, quarry unlocking
		_SetVariableBool("SawMillEnabled", true)
		FK.sawMillUnlocked = true

--		_SetVariableBool("StoneMineEnabled", true)
--		FK.quarryUnlocked = true
	end

	if (FK.farmsUnlocked == false and FK.sawMillBuilt and FK.quarryBuilt) then		-- farm, watermill unlocking
		FK.farmsUnlocked = true
		_SetVariableBool("Farm01Enabled", true)
		_SetVariableBool("Farm03Enabled", true)
		_SetVariableBool("Farm04Enabled", true)
		FK.waterMillUnlocked = true
		_SetVariableBool("WaterMillEnabled", true)
	end

	if (FK.goldMineUnlocked == false and FK.tavernBuilt and FK.windMillBuilt) then	-- goldmine unlocking
		FK.goldMineUnlocked = true
		_SetVariableBool("GoldMineEnabled", true)
	end

			--=======--
	---=== LEVEL-02 SPECIFIC SCRIPT ===---
	if (FK.msg01TimerIsOver and event.GameState == "MainGame") then
		FK.msg01TimerIsOver = false
		_EnableButton("BuildButton", true)
		_ShowDialog("Dialog01", "m02_msg01", "Sancho", "Ok")
	end

	if (event.GameState == "MainGame" and FK.windMillBuilt and FK.farm02Built and FK.activeObj == 4 and FK.completedObj == 4) then
		_ShowDialog("Dialog05", "m02_msg05", "Sancho", "Ok")
	end

	if (event.GameState == "MainGame" and FK.activeObj == 6 and FK.completedObj == 6) then
		FK.tavernUnlocked = true
		_SetVariableBool("TavernEnabled", true)
		_Blink("BuildButton", true)
		FK.activeObj = 7

		_ShowDialog("Dialog06", "m02_msg06", "Sancho", "Ok")
	end

	if (FK.pirateEnabled and event.GameState == "MainGame") then
		_Log("Pirate created.")
		FK.pirateNum = math.random(5)
		_CreatePirate("Pir0" .. FK.pirateNum, "m02_msg_pirate_demand", FK.pirateNum, "Meal", 10)
		FK.pirateEnabled = false
	end

	if (event.GameState == "MainGame" and FK.activeObj == 7.5 and FK.completedObj == 7.5 and FK.tavernBuilt) then
		FK.activeObj = 8
		_StartCutscene("cutscene_02b", 6, 0)
	end
--	_Log("Act: " .. FK.activeObj .. " Comp: " .. FK.completedObj)
end

			--=======--
	---=== LEVEL-02 SPECIFIC SCRIPT ===---
function OnCutsceneEnded_cutscene_02a()
	_StartIntro()		-- imp ship in, npcs descend
end

function OnIntroEnded()
	_ShowGUI(true)					-- player gets control

	_EnableButton("DiaryButton", false)				-- Diary menu disabled.
	_EnableButton("ScreenSaverButton", false)		-- Pause/screensave menu disabled.
	_EnableButton("BuildButton", false)

	_ActivateMiniGame("Farm", false)
	_ActivateMiniGame("SawMill", false)
	_ActivateMiniGame("WaterMill", false)
	_ActivateMiniGame("StoneMine", false)
	_ActivateMiniGame("WindMill", false)
	_ActivateMiniGame("GoldMine", false)

	_CreateTimer("first_dialog_timer", 0, 2)
end

function OnTimerEnded_first_dialog_timer()
	_ShowDialog("Dialog00a", "m02_msg00a", "Sancho", "Ok")
end

function OnDialogClosed_Dialog00a()
	_ShowDialog("Dialog00a2", "m02_msg00a2", "Sancho", "Ok")
end

function OnDialogClosed_Dialog00a2()
	_ShowDialog("Dialog00b", "m02_msg00b", "Sancho", "Ok")
end

function OnDialogClosed_Dialog00b()
	_ShowDialog("Dialog00b2", "m02_msg00b2", "Sancho", "Ok")
end

function OnDialogClosed_Dialog00b2()
	_Blink("GemButton", true)
	_ShowBuildingArrow("SawMill", true)
	_ShowObjective("m02_msg_obj01")
	FK.activeObj = 1
end

function OnChestOpened()
	if (FK.activeObj == 1 and FK.completedObj == 0) then
		_StartParticle("global_warning", 522, 370)
	end
end

function OnChestClosed()
	if (FK.activeObj == 1 and FK.completedObj == 0) then
		_StopParticle()
	end
end

function OnChestClosedExit()
	if (FK.activeObj == 1 and FK.completedObj == 0) then
		_StopParticle()
	end
end

function OnOrbUsed()
	_ShowBuildingArrow("SawMill", false)
	_Blink("GemButton", false)
	_ActivateMiniGame("SawMill", true)

	_StartParticle("global_warning", 325, 18)						-- wood resource

	_CompleteObjective("m02_msg_obj01")
	FK.completedObj = 1

	_ShowWarning("m02_warn00")

	_CreateTimer("msg01timer", 0, 10)
end

function OnMiniGameEnter_SawMill()
	if (FK.activeObj == 1 and FK.completedObj == 1 and FK.msg01TimerIsOver == false) then
		_StopParticle()
		_HideWarning()
	end
end

function OnMiniGameExit_SawMill()
	if (FK.activeObj == 1 and FK.completedObj == 1 and FK.msg01TimerIsOver == false) then
		_StartParticle("global_warning", 325, 18)						-- wood resource
		_ShowWarning("m02_warn00")
	end
end

function OnTimerEnded_msg01timer()
	_StopParticle()
	FK.msg01TimerIsOver = true
	_HideWarning()
end

function OnDialogClosed_Dialog01()
	_ShowDialog("Dialog01b", "m02_msg01b", "Sancho", "Ok")
end

function OnDialogClosed_Dialog01b()
	_ShowDialog("Dialog02", "m02_msg02", "Sancho", "Ok")
end

function OnDialogClosed_Dialog02()
	_SetVariableBool("Farm02Enabled", true)
	_Blink("BuildButton", true)
	_ShowObjective("m02_msg_obj02")
	FK.activeObj = 2
end


function OnBuildingStarted_Farm02()
	if (FK.completedObj == 1) then
		FK.completedObj = 2
		_CompleteObjective("m02_msg_obj02")

		_ShowDialog("Dialog03", "m02_msg03", "Sancho", "Ok")
	end
end

function OnDialogClosed_Dialog03()
	FK.windMillUnlocked = true
	_SetVariableBool("WindMillEnabled", true)
	_Blink("BuildButton", true)
	_ShowObjective("m02_msg_obj03")
	FK.activeObj = 3
end

function OnBuildingStarted_WindMill()
	if (FK.completedObj == 2) then
		FK.completedObj = 3
		_CompleteObjective("m02_msg_obj03")

		_StartParticle("global_warning", 655, 18)						-- food resource

		_ActivateMiniGame("Farm", true)
		_ShowDialog("Dialog04", "m02_msg04", "Sancho", "Ok")
	end
end

function OnDialogClosed_Dialog04()
	_StopParticle()
	_ShowBuildingArrow("Farm01", true)
	_ShowBuildingArrow("Farm02", true)
	_ShowBuildingArrow("Farm03", true)
	_ShowBuildingArrow("Farm04", true)
	_ShowDialog("Dialog04b", "m02_msg04b", "Sancho", "Ok")
end

function OnDialogClosed_Dialog04b()
	_ShowObjective("m02_msg_obj035")
	FK.activeObj = 3.5
end

function OnMiniGameEnter_Farm()
	if (FK.activeObj == 3.5 and FK.completedObj == 3) then
		_CompleteObjective("m02_msg_obj035")
		FK.completedObj = 3.5

      _ShowObjective("m02_msg_obj04")
		FK.activeObj = 4
		_ShowMiniGameDialog("DialogFarm01", "m02_msg_farm01", "Sancho", "Ok")
	end
end

function OnDialogClosed_DialogFarm01()
	_ShowMiniGameDialog("DialogFarm01b", "m02_msg_farm01b", "Sancho", "Ok")
end

--function OnDialogClosed_DialogFarm01b() -- dev
--	_CompleteObjective("m02_msg_obj04") -- dev
--	FK.completedObj = 4	-- dev
--end

function OnBoxComplexCompleted()
	FK.boxGroupFilled = FK.boxGroupFilled + 1

	if (FK.activeObj == 4 and FK.completedObj == 3.5) then
		if (FK.boxGroupFilled == 1) then
			_ShowMiniGameDialog("DialogFarm02", "m02_msg_farm02", "Sancho", "Ok")
		elseif (FK.boxGroupFilled == 2) then
			_ShowMiniGameDialog("DialogFarm03", "m02_msg_farm03", "Sancho", "Ok")
		elseif (FK.boxGroupFilled == 3) then
		_CompleteObjective("m02_msg_obj04")
			FK.completedObj = 4
			_ShowBuildingArrow("Farm01", false)
			_ShowBuildingArrow("Farm02", false)
			_ShowBuildingArrow("Farm03", false)
			_ShowBuildingArrow("Farm04", false)
			_ShowMiniGameDialog("DialogFarm04", "m02_msg_farm04", "Sancho", "Ok")
		end
	end

	if (FK.activeObj == 7.5 and FK.completedObj == 7) then
		if (FK.boxGroupFilled == 1) then
			_CompleteObjective("m02_msg_obj075")
			FK.completedObj = 7.5
			_ShowMiniGameDialog("DialogFarm05", "m02_msg_farm05", "Sancho", "Ok")
			_ActivateMiniGame("Tavern", true)
		end
	end
end

function OnDialogClosed_DialogFarm04()
	_ShowMiniGameDialog("DialogFarm04b", "m02_msg_farm04b", "Sancho", "Ok")
end

---
function OnDialogClosed_Dialog05()
	_ActivateMiniGame("WindMill", true)
	_ShowBuildingArrow("WindMill", true)
	_ShowObjective("m02_msg_obj05")
	FK.activeObj = 5
end

function OnMiniGameEnter_WindMill()
	if (FK.completedObj == 4) then
		FK.completedObj = 5
		_CompleteObjective("m02_msg_obj05")

		_ShowBuildingArrow("WindMill", false)

		_ShowObjective("m02_msg_obj06")
		FK.activeObj = 6
		_ShowMiniGameDialog("DialogWindMill_01", "m02_msg_windmill_01", "Sancho", "Ok")
	end
end

function OnDialogClosed_DialogWindMill_01()
		_ShowMiniGameDialog("DialogWindMill_01b", "m02_msg_windmill_01b", "Sancho", "Ok")
--	_CompleteObjective("m02_msg_obj06")	-- dev
--	FK.completedObj = 6	-- dev
end

function OnSackCompleted()
	FK.sackFilled = FK.sackFilled + 1

	if (FK.activeObj == 6 and FK.completedObj == 5) then
		if (FK.sackFilled == 1) then
			_ShowMiniGameDialog("DialogWindMill_02", "m02_msg_windmill_02", "Sancho", "Ok")
		elseif (FK.sackFilled == 2) then
			_ShowMiniGameDialog("DialogWindMill_03", "m02_msg_windmill_03", "Sancho", "Ok")
		elseif (FK.sackFilled == 3) then
			FK.completedObj = 6
			_CompleteObjective("m02_msg_obj06")
			_ShowMiniGameDialog("DialogWindMill_05", "m02_msg_windmill_05", "Sancho", "Ok")
		end
	end
end

function OnDialogClosed_DialogWindMill_03()
	_ShowMiniGameDialog("DialogWindMill_04", "m02_msg_windmill_04", "Sancho", "Ok")
end

function OnDialogClosed_Dialog06()
	_ShowObjective("m02_msg_obj07")
end

function OnBuildingStarted_Tavern()
	_CompleteObjective("m02_msg_obj07")
	FK.completedObj = 7

	FK.pirateEnabled = true
	_Log("pirate enabled.")
end

function OnDialogClosed_Dialog_p_s()
	_ShowDialog("Dialog07", "m02_msg07", "Sancho", "Ok")
end

function OnDialogClosed_Dialog07()
	_ShowObjective("m02_msg_obj075")
	FK.activeObj = 7.5
	FK.boxGroupFilled = 0
end

function OnBuildingCompleted_Tavern()
	FK.tavernBuilt = true
	_ActivateMiniGame("Tavern", false)
end

function OnCutsceneEnded_cutscene_02b()
	_ShowDialog("Dialog08", "m02_msg08", "Sancho", "Ok")
end

function OnDialogClosed_Dialog08()
	_ShowDialog("Dialog08b", "m02_msg08b", "Sancho", "Ok")
end

function OnDialogClosed_Dialog08b()
	_ShowDialog("Dialog09", "m02_msg09", "Sancho", "Ok")
end

function OnDialogClosed_Dialog09()
	_Blink("BuildButton", true)

	_SetVariableBool("PalaceEnabled", true)
	FK.palaceUnlocked = true

	_ShowObjective("m02_msg_obj08")
end

--
function OnBuildMenuOpened()
	_Blink("BuildButton", false)

	if (FK.activeObj == 8 and FK.completedObj == 7.5) then
		_CompleteObjective("m02_msg_obj08")
		FK.completedObj = 8

		_ShowDialog("Dialog10", "m02_msg10", "Sancho", "Ok")
	elseif (FK.activeObj == 9 and FK.completedObj == 8) then
		_ShowWarning("m02_warn01")
	end
end

function OnDialogClosed_Dialog10()
	_ShowDialog("Dialog10b", "m02_msg10b", "Sancho", "Ok")
end

function OnDialogClosed_Dialog10b()
	_ShowObjective("m02_msg_obj09")
	FK.activeObj = 9
	_ShowWarning("m02_warn01")
end

function OnBuildMenuClosed()
	_Blink("BuildButton", false)

	if (FK.activeObj == 9 and FK.completedObj == 8) then
		_HideWarning()
	end

	if (FK.activeObj == 2 and FK.completedObj == 1) then
		_ShowBuildingArrow("House02", false)
	end
end

function OnBuildingStarted_Palace()
	_CompleteObjective("m02_msg_obj09")
	FK.completedObj = 9

	_Blink("BuildButton", false)
	_EnableButton("GemButton", false)
	_EnableButton("DiaryButton", false)
	_EnableButton("ScreenSaverButton", false)
	_EnableButton("BuildButton", false)

	_ShowObjective("msg_obj_last")
	_ShowGUI(false)
end

------------------------------
-- PIRATES
function OnDialogClosed_Pir01()	-- pay
	if (10 <= event.Meal) then
		_ModifyResource("Meal", -10)
	end
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info01", "Sancho", "Ok")
end
function OnDialogClosed2ndButton_Pir01()	-- refuse
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info02", "Sancho", "Ok")
end

function OnDialogClosed_Pir02()	-- pay
	if (10 <= event.Meal) then
		_ModifyResource("Meal", -10)
	end
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info01", "Sancho", "Ok")
end
function OnDialogClosed2ndButton_Pir02()	-- refuse
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info02", "Sancho", "Ok")
end

function OnDialogClosed_Pir03()	-- pay
	if (10 <= event.Meal) then
		_ModifyResource("Meal", -10)
	end
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info01", "Sancho", "Ok")
end
function OnDialogClosed2ndButton_Pir03()	-- refuse
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info02", "Sancho", "Ok")
end

function OnDialogClosed_Pir04()	-- pay
	if (10 <= event.Meal) then
		_ModifyResource("Meal", -10)
	end
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info01", "Sancho", "Ok")
end
function OnDialogClosed2ndButton_Pir04()	-- refuse
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info02", "Sancho", "Ok")
end

function OnDialogClosed_Pir05()	-- pay
	if (10 <= event.Meal) then
		_ModifyResource("Meal", -10)
	end
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info01", "Sancho", "Ok")
end
function OnDialogClosed2ndButton_Pir05()	-- refuse
	_ShowDialog("Dialog_p_s", "m02_msg_pirate_info02", "Sancho", "Ok")
end

-----

			--=======--
	---=== HOUSES FINISHED ===---
function OnBuildingCompleted_House01()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

function OnBuildingCompleted_House02()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

function OnBuildingCompleted_House03()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

function OnBuildingCompleted_House04()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

			--=======--
	---=== FARMS FINISHED ===---
function OnBuildingCompleted_Farm01()
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

function OnBuildingCompleted_Farm02()
	FK.farm02Built = true
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

function OnBuildingCompleted_Farm03()
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

function OnBuildingCompleted_Farm04()
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

			--=======--
	---=== OTHER BUILDINGS FINISHED ===---
function OnBuildingCompleted_SawMill()
	FK.sawMillBuilt = true
end

function OnBuildingCompleted_WaterMill()
	FK.waterMillBuilt = true
end

function OnBuildingCompleted_StoneMine()
	FK.quarryBuilt = true
end

function OnBuildingCompleted_WindMill()
	FK.windMillBuilt = true
end

function OnBuildingCompleted_GoldMine()
	FK.goldMineBuilt = true
end

			--=======--
	---=== PALACE PHASES FINISHED ===---
function OnBuildingCompleted_PalacePhase01()
	FK.palaceP01Built = true
end

function OnBuildingCompleted_PalacePhase02()
	FK.palaceP02Built = true
end

function OnBuildingCompleted_PalacePhase03()
	FK.palaceP03Built = true
end

function OnBuildingCompleted_PalacePhase04()
	FK.palaceP04Built = true
end

function OnBuildingCompleted_PalacePhase05()
	FK.palaceP05Built = true
	_CompleteObjective("msg_obj_last")
	MissionComplete()
end

function OnCtrlE()
	MissionComplete()
end

function OnCtrlR()
	_ModifyResource("Wood", 500)
	_ModifyResource("Stone", 500)
	_ModifyResource("Gold", 500)

	_ModifyResource("Meal", 500)
	_ModifyResource("Flour", 500)
end

			--=======--
	---=== Mission complete ===---
function MissionComplete()
	_ShowGUI(false)
	_StartOutro()
end

function OnOutroEnded()
	_ShowDialog("Dialog_miss_comp", "mission_completed", "Aurelius", "Ok")
end

function OnDialogClosed_Dialog_miss_comp()
	_EndMission()
end
